<?php

namespace App\Modules\FactReceiptDetail\Application\Create;

use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceiptDetail\Domain\IdFactReceiptDetail;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetail;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailAmount;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailDiscount;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailStatus;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailTotal;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailUnitPrice;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFactReceiptDetailQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptDetailCreator $updater)
    {
    }

    public function __invoke(CreateFactReceiptDetailQuery $query): CreateFactReceiptDetailResponse
    {
        $model = new FactReceiptDetail(
            new IdFactReceiptDetail(0),
            new FactReceiptDetailAmount($query->amount()),
            new FactReceiptDetailUnitPrice($query->unitPrice()),
            new FactReceiptDetailDiscount($query->discount()),
            new FactReceiptDetailTotal($query->total()),
            new FactReceiptDetailStatus($query->status()),
            new IdFactProduct($query->idFactProduct()),
            new IdFactTypeOperation($query->idFactTypeOperation()),
            new IdFactUnit($query->idFactUnit()),
            new IdFactReceipt($query->idFactReceipt()),
        );
        return $this->updater->__invoke($model);
    }
}
