<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactReceipt implements StorageCriteria
{

    public function __construct(private string $action) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactReceipt::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactReceipt_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactReceipt_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactReceipt_Status` = 0';
        } else {
            $where = '`ftd`.`FactReceipt_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_receipt` `ftd`
            WHERE $where",
            [ ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
