<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class InsertFactReceipt extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactReceipt::class, 'Id_FactReceipt'),
            new AggregateAttribute('date', FactReceiptDate::class, 'FactReceipt_Date'),
            new AggregateAttribute('dateUpdate', FactReceiptDateUpdate::class, 'FactReceipt_DateUpdate'),
            new AggregateAttribute('dateEmission', FactReceiptDateEmission::class, 'FactReceipt_DateEmission'),
            new AggregateAttribute('noDocument', FactReceiptNoDocument::class, 'FactReceipt_NoDocument'),
            new AggregateAttribute('businessName', FactReceiptBusinessName::class, 'FactReceipt_BusinessName'),
            new AggregateAttribute('email', FactReceiptEmail::class, 'FactReceipt_Email'),
            new AggregateAttribute('address', FactReceiptAddress::class, 'FactReceipt_Address'),
            new AggregateAttribute('licensePlate', FactReceiptLicensePlate::class, 'FactReceipt_LicensePlate'),
            new AggregateAttribute('currency', FactReceiptCurrency::class, 'FactReceipt_Currency'),
            new AggregateAttribute('responseMessage', FactReceiptResponseMessage::class, 'FactReceipt_ResponseMessage'),
            new AggregateAttribute('status', FactReceiptStatus::class, 'FactReceipt_Status'),
            new AggregateAttribute('idFactTypeReceipt', IdFactTypeReceipt::class, 'Id_FactTypeReceipt'),
            new AggregateAttribute('idFactTypeDocument', IdFactTypeDocument::class, 'Id_FactTypeDocument'),
            new AggregateAttribute('idFactPaymentMethod', IdFactPaymentMethod::class, 'Id_FactPaymentMethod'),
            new AggregateAttribute('idFactCurrency', IdFactCurrency::class, 'Id_FactCurrency'),
            new AggregateAttribute('idCashMovement', IdCashMovement::class, 'Id_CashMovement'),
        ];
    }

    public function __construct(
        private IdFactReceipt $id,
        private FactReceiptDate $date,
        private FactReceiptDateUpdate $dateUpdate,
        private FactReceiptDateEmission $dateEmission,
        private FactReceiptNoDocument $noDocument,
        private FactReceiptBusinessName $businessName,
        private FactReceiptEmail $email,
        private FactReceiptAddress $address,
        private FactReceiptLicensePlate $licensePlate,
        private FactReceiptCurrency $currency,
        private FactReceiptResponseMessage $responseMessage,
        private FactReceiptStatus $status,
        private IdFactTypeReceipt $idFactTypeReceipt,
        private IdFactTypeDocument $idFactTypeDocument,
        private IdFactPaymentMethod $idFactPaymentMethod,
        private IdFactCurrency $idFactCurrency,
        private IdCashMovement $idCashMovement,
    ) {
    }

    public function id(): IdFactReceipt
    {
        return $this->id;
    }

    public function date(): FactReceiptDate
    {
        return $this->date;
    }

    public function dateUpdate(): FactReceiptDateUpdate
    {
        return $this->dateUpdate;
    }

    public function dateEmission(): FactReceiptDateEmission
    {
        return $this->dateEmission;
    }

    public function noDocument(): FactReceiptNoDocument
    {
        return $this->noDocument;
    }

    public function businessName(): FactReceiptBusinessName
    {
        return $this->businessName;
    }

    public function email(): FactReceiptEmail
    {
        return $this->email;
    }

    public function address(): FactReceiptAddress
    {
        return $this->address;
    }

    public function licensePlate(): FactReceiptLicensePlate
    {
        return $this->licensePlate;
    }

    public function currency(): FactReceiptCurrency
    {
        return $this->currency;
    }

    public function responseMessage(): FactReceiptResponseMessage
    {
        return $this->responseMessage;
    }

    public function status(): FactReceiptStatus
    {
        return $this->status;
    }

    public function idFactTypeReceipt(): IdFactTypeReceipt
    {
        return $this->idFactTypeReceipt;
    }

    public function idFactTypeDocument(): IdFactTypeDocument
    {
        return $this->idFactTypeDocument;
    }

    public function idFactPaymentMethod(): IdFactPaymentMethod
    {
        return $this->idFactPaymentMethod;
    }

    public function idFactCurrency(): IdFactCurrency
    {
        return $this->idFactCurrency;
    }

    public function idCashMovement(): IdCashMovement
    {
        return $this->idCashMovement;
    }
}
