<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactReceipt implements StorageCriteria
{

    public function __construct(
        private IdFactReceipt $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactReceipt::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_receipt` `ftd`
            WHERE `ftd`.`Id_FactReceipt` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactReceiptNotFound();
        }
        return $data[0];
    }
}
