<?php

namespace App\Modules\FactReceipt\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class FactReceiptUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $dateEmission,
        private string $noDocument,
        private string $businessName,
        private string $email,
        private string $address,
        private string $licensePlate,
        private string $currency,
        private int $idFactTypeReceipt,
        private int $idFactTypeDocument,
        private int $idFactPaymentMethod,
        private int $idFactCurrency,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function dateEmission(): string
    {
        return $this->dateEmission;
    }

    public function noDocument(): string
    {
        return $this->noDocument;
    }

    public function businessName(): string
    {
        return $this->businessName;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function address(): string
    {
        return $this->address;
    }

    public function licensePlate(): string
    {
        return $this->licensePlate;
    }

    public function currency(): string
    {
        return $this->currency;
    }

    public function idFactTypeReceipt(): int
    {
        return $this->idFactTypeReceipt;
    }

    public function idFactTypeDocument(): int
    {
        return $this->idFactTypeDocument;
    }

    public function idFactPaymentMethod(): int
    {
        return $this->idFactPaymentMethod;
    }

    public function idFactCurrency(): int
    {
        return $this->idFactCurrency;
    }
}
