<?php

namespace App\Modules\FactReceipt\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateFactReceiptQuery implements Query
{
    public function __construct(
        private string $date,
        private string $dateUpdate,
        private string $dateEmission,
        private string $noDocument,
        private string $businessName,
        private string $email,
        private string $address,
        private string $licensePlate,
        private string $currency,
        private string $responseMessage,
        private int $status,
        private int $idFactTypeReceipt,
        private int $idFactTypeDocument,
        private int $idFactPaymentMethod,
        private int $idFactCurrency,
    ) {
    }

    public function date(): string
    {
        return $this->date;
    }

    public function dateUpdate(): string
    {
        return $this->dateUpdate;
    }

    public function dateEmission(): string
    {
        return $this->dateEmission;
    }

    public function noDocument(): string
    {
        return $this->noDocument;
    }

    public function businessName(): string
    {
        return $this->businessName;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function address(): string
    {
        return $this->address;
    }

    public function licensePlate(): string
    {
        return $this->licensePlate;
    }

    public function currency(): string
    {
        return $this->currency;
    }

    public function responseMessage(): string
    {
        return $this->responseMessage;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idFactTypeReceipt(): int
    {
        return $this->idFactTypeReceipt;
    }

    public function idFactTypeDocument(): int
    {
        return $this->idFactTypeDocument;
    }

    public function idFactPaymentMethod(): int
    {
        return $this->idFactPaymentMethod;
    }

    public function idFactCurrency(): int
    {
        return $this->idFactCurrency;
    }
}
