<?php

namespace App\Modules\FactProduct\Application\Update;

use App\Modules\FactProduct\Application\Update\FactProductUpdaterResponse;
use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactProduct\Domain\FactProductRepository;

final class FactProductUpdater
{
    public function __construct(private FactProductRepository $repository)
    {
    }

    public function __invoke(FactProduct $lead): FactProductUpdaterResponse
    {
        return new FactProductUpdaterResponse($this->repository->update($lead));
    }
}
