<?php

namespace App\Modules\FactProduct\Application\List;

use App\Modules\FactProduct\Application\FactProductResponse;
use App\Modules\FactProduct\Application\FactProductResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactProductListerQueryHandler implements QueryHandler
{
    public function __construct(private FactProductLister $lister)
    {
    }

    public function __invoke(FactProductListerQuery $query): FactProductResponses
    {
        return new FactProductResponses(...array_map(
            fn ($index) => new FactProductResponse(
                $index->id()->value(),
                $index->code()->value(),
                $index->name()->value(),
                $index->idProduct()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
