<?php

namespace App\Modules\FactProduct\Application\Index;

use App\Modules\FactProduct\Application\Index\FactProductIndexerResponse;
use App\Modules\FactProduct\Domain\IdFactProduct;
use App\Modules\FactProduct\Domain\FactProductRepository;
use App\Modules\FactProduct\Domain\IndexFactProduct;

final class FactProductIndexer
{
    public function __construct(private FactProductRepository $repository)
    {
    }

    public function __invoke(IdFactProduct $idFactProduct)
    {
        $index = $this->repository->find(new IndexFactProduct($idFactProduct));
        return $index;
    }
}
