<?php

namespace App\Modules\FactPaymentMethod\Application\List;

use App\Modules\FactPaymentMethod\Application\FactPaymentMethodResponse;
use App\Modules\FactPaymentMethod\Application\FactPaymentMethodResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListFactPaymentMethodQueryHandler implements QueryHandler
{
    public function __construct(private FactPaymentMethodLister $lister)
    {
    }

    public function __invoke(ListFactPaymentMethodQuery $query): FactPaymentMethodResponses
    {
        return new FactPaymentMethodResponses(...array_map(
            fn ($index) => new FactPaymentMethodResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
