<?php

namespace App\Modules\FactCurrency\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactCurrency extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactCurrency::class, 'Id_FactCurrency', 'primary'),
            new AggregateAttribute('name', FactCurrencyName::class, 'FactCurrency_Name'),
            new AggregateAttribute('abrv', FactCurrencyAbrv::class, 'FactCurrency_Abrv'),
            new AggregateAttribute('status', FactCurrencyStatus::class, 'FactCurrency_Status'),
        ];
    }

    protected static function table(): string
    {
        return 't_fact_currency';
    }

    public function __construct(
        protected IdFactCurrency $id,
        protected FactCurrencyName $name,
        protected FactCurrencyAbrv $abrv,
        protected FactCurrencyStatus $status,
    ) {
    }

    public function id(): IdFactCurrency
    {
        return $this->id;
    }

    public function name(): FactCurrencyName
    {
        return $this->name;
    }

    public function abrv(): FactCurrencyAbrv
    {
        return $this->abrv;
    }

    public function status(): FactCurrencyStatus
    {
        return $this->status;
    }

    public function setName(FactCurrencyName $name): void
    {
        $this->name = $name;
    }

    public function setAbrv(FactCurrencyAbrv $abrv): void
    {
        $this->abrv = $abrv;
    }

    public function setStatus(FactCurrencyStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new FactCurrencyStatus(FactCurrencyStatus::DELETED);
    }
}
