<?php

namespace App\Modules\FactCurrency\Application\Index;

use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactCurrency\Domain\FactCurrencyRepository;
use App\Modules\FactCurrency\Domain\IndexFactCurrency;

final class FactCurrencyIndexer
{
    public function __construct(private FactCurrencyRepository $repository)
    {
    }

    public function __invoke(IdFactCurrency $idFactCurrency, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexFactCurrency($idFactCurrency, $lockInShare));
        return $index;
    }
}
