<?php

namespace App\Modules\ExternalReview\Application;

use App\Modules\ExternalReview\Domain\ExternalReviewRepository;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class GroupExternalReviewFinder
{

    private ExternalReviewRepository $repository;

    public function __construct(ExternalReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroupPassenger $idGroupPassenger, $action)
    {
        return $this->repository->groupFind($idGroupPassenger, $action);
    }
}
