<?php

namespace App\Modules\ExternalApiRequest\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateExternalApiRequestQuery implements Query
{
    public function __construct(
        private string $date,
        private string $apiUrl,
        private string $method,
        private string $body,
        private string $response,
        private int $status,
    ) {
    }
    public function date(): string
    {
        return $this->date;
    }
    public function apiUrl(): string
    {
        return $this->apiUrl;
    }
    public function method(): string
    {
        return $this->method;
    }
    public function body(): string
    {
        return $this->body;
    }
    public function response(): string
    {
        return $this->response;
    }
    public function status(): int
    {
        return $this->status;
    }
}
