<?php

namespace App\Modules\EmailShip\Domain;

use ArrayAccess;
use ArrayIterator;
use Countable;
use IteratorAggregate;
use TypeError;

class EmailCollection implements Countable, ArrayAccess, IteratorAggregate
{

    private array $data;

    public function __construct(EmailData ...$data)
    {
        $this->data = $data;
    }

    public function getMails()
    {
        return implode(',', array_map(fn($mail) => $mail->email(), $this->data));
    }

    public function getMailData()
    {
        return array_map(fn($mail) => [ 'email' => $mail->email() ], $this->data);
    }

    public function count(): int
    {
        return count($this->data);
    }

    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->data);
    }
 
    public function offsetExists($offset): bool
    {
        return isset($this->data[$offset]);
    }
 
    public function offsetGet($offset): EmailData
    {
        return $this->data[$offset];
    }
 
    public function offsetSet($offset, $value) : void
    {
        if ($value instanceof EmailData) {
            $this->data[$offset] = $value;
        } else {
            throw new TypeError("Invalid value type");
        }
    }
 
    public function offsetUnset($offset) : void
    {
        unset($this->data[$offset]);
    }
}
