<?php

namespace App\Modules\CashMovementFactReceipt\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class CashMovementFactReceipt extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdCashMovementFactReceipt::class, 'Id_CashMovementFactReceipt'),
            new AggregateAttribute('status', CashMovementFactReceiptStatus::class, 'CashMovementFactReceipt_Status'),
            new AggregateAttribute('idCashMovement', IdCashMovement::class, 'Id_CashMovement'),
            new AggregateAttribute('idFactReceipt', IdFactReceipt::class, 'Id_FactReceipt'),
        ];
    }

    public function __construct(
        private IdCashMovementFactReceipt $id,
        private CashMovementFactReceiptStatus $status,
        private IdCashMovement $idCashMovement,
        private IdFactReceipt $idFactReceipt,
    ) {
    }

    public function id(): IdCashMovementFactReceipt
    {
        return $this->id;
    }

    public function status(): CashMovementFactReceiptStatus
    {
        return $this->status;
    }

    public function idCashMovement(): IdCashMovement
    {
        return $this->idCashMovement;
    }

    public function idFactReceipt(): IdFactReceipt
    {
        return $this->idFactReceipt;
    }

}
