<?php

namespace App\Modules\CashMovementFactReceipt\Application\Update;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\IdCashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CashMovementFactReceiptUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementFactReceiptUpdater $updater)
    {
    }

    public function __invoke(CashMovementFactReceiptUpdaterQuery $query): CashMovementFactReceiptUpdaterResponse
    {
        $model = new CashMovementFactReceipt(
            new IdCashMovementFactReceipt($query->id()),
            new CashMovementFactReceiptStatus($query->status()),
            new IdCashMovement($query->idCashMovement()),
            new IdFactReceipt($query->idFactReceipt()),
        );
        return $this->updater->__invoke($model);
    }
}
