<?php

namespace App\Modules\CashMovementFactReceipt\Application\GetCurrent;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponse;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class GetCurrentCashMovementFactReceiptQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementFactReceiptCurrentGetter $currentGetter)
    {
    }

    public function __invoke(GetCurrentCashMovementFactReceiptQuery $query): CashMovementFactReceiptResponses
    {
        $model = $this->currentGetter->__invoke(new IdCashMovement($query->idCashMovement()));
        if ($model !== null) {
            $response = new CashMovementFactReceiptResponse(
                $model->id()->value(),
                $model->status()->value(),
                $model->idCashMovement()->value(),
                $model->idFactReceipt()->value(),
            );
            return new CashMovementFactReceiptResponses($response);
        };
        return new CashMovementFactReceiptResponses();
    }
}
