<?php

namespace App\Modules\CashMovementFactReceipt\Application\Create;

use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;

final class CashMovementFactReceiptCreator
{
    public function __construct(private CashMovementFactReceiptRepository $repository)
    {
    }

    public function __invoke(CashMovementFactReceipt $creator): CreateCashMovementFactReceiptResponse
    {
        return new CreateCashMovementFactReceiptResponse($this->repository->insert($creator));
    }
}
