<?php

namespace App\Modules\CashMovementDetail\Application\ListForFacture;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListForFactureCashMovementDetailQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementDetailForFactureLister $lister)
    {
    }

    public function __invoke(ListForFactureCashMovementDetailQuery $query): ListForFactureCashMovementDetailResponse
    {
        return new ListForFactureCashMovementDetailResponse(
            $this->lister->__invoke(new IdCashMovement($query->id()), $query->action())
        );
    }
}
