<?php

namespace App\Modules\CashMovement\Infraestructure;

use App\Modules\CashMovement\Domain\CashMovementCycleType;
use App\Modules\CashMovement\Domain\CashMovementRepository;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\Shared\Infraestructure\Format1Requester;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlCashMovementRepository implements CashMovementRepository
{
    public function index(IdCashMovement $idCashMovement)
    {
        return Format1Requester::request(
            'CALL sp_cash_movement_index(?)',
            [
                $idCashMovement->value(),
            ]
        );
    }
    public function delete(IdCashMovement $cashMovement)
    {
    }

    public function updateCycleType(IdCashMovement $idCashMovement, CashMovementCycleType $cycleType)
    {
        return Requester::requestUpdate(
            'CALL sp_cash_movement_update_cycle_type(?,?,@sts,@cod,@msg)',
            [
                $idCashMovement->value(),
                $cycleType->value(),
            ]
        );
    }
}
