<?php

namespace App\Modules\CashMovement\Application;

use App\Modules\CashMovement\Domain\CashMovementAddress;
use App\Modules\CashMovement\Domain\CashMovementCardIssuer;
use App\Modules\CashMovement\Domain\CashMovementCardNumber;
use App\Modules\CashMovement\Domain\CashMovementCity;
use App\Modules\CashMovement\Domain\CashMovementCountry;
use App\Modules\CashMovement\Domain\CashMovementEmail;
use App\Modules\CashMovement\Domain\CashMovementLastName;
use App\Modules\CashMovement\Domain\CashMovementName;
use App\Modules\CashMovement\Domain\CashMovementReceiptNumber;
use App\Modules\CashMovement\Domain\CashMovementRemark;
use App\Modules\CashMovement\Domain\CashMovementUpdateRepository;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovement\Domain\UpdateCashMovement;
use App\Modules\TypePayment\Domain\IdTypePayment;

class CashMovementUpdater
{
    public function __construct(
        private CashMovementUpdateRepository $repository
    ) {
    }

    public function __invoke(
        int $idCashMovement,
        string $cashMovementName,
        string $cashMovementLastName,
        string $cashMovementEmail,
        string $cashMovementCountry,
        string $cashMovementCity,
        string $cashMovementAddress,
        string $cashMovementReceiptNumber,
        string $cashMovementCardNumber,
        string $cashMovementCardIssuer,
        string $cashMovementRemark,
        int $idTypePayment
    ) {
        return $this->repository->update(
            new UpdateCashMovement(
                new IdCashMovement($idCashMovement),
                new CashMovementName($cashMovementName),
                new CashMovementLastName($cashMovementLastName),
                new CashMovementEmail($cashMovementEmail),
                new CashMovementCountry($cashMovementCountry),
                new CashMovementCity($cashMovementCity),
                new CashMovementAddress($cashMovementAddress),
                new CashMovementReceiptNumber($cashMovementReceiptNumber),
                new CashMovementCardNumber($cashMovementCardNumber),
                new CashMovementCardIssuer($cashMovementCardIssuer),
                new CashMovementRemark($cashMovementRemark),
                new IdTypePayment($idTypePayment)
            )
        );
    }
}
