<?php

namespace App\Modules\CalendarTour\Application\ListPassengerAlter;

use App\Modules\CalendarTour\Domain\CalendarTourAlterRepository;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class CalendarTourAlterPassengerLister
{
    public function __construct(private CalendarTourAlterRepository $repository)
    {
    }

    public function __invoke(
        IdTour $idTour,
        DateStart $dateStart
    ): ListPassengerAlterCalendarTourResponse {
        return new ListPassengerAlterCalendarTourResponse($this->repository->tourPassengerList(
            $idTour,
            $dateStart
        ));
    }
}
