<?php

namespace App\Modules\BookingUpgradePassenger\Application\Reset;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;

class BookingUpgradePassengerResetter
{

    private BookingUpgradePassengerRepository $repository;

    public function __construct(BookingUpgradePassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingUpgradePassenger $id)
    {
        return new ResetBookingUpgradePassengerResponse($this->repository->reset($id));
    }
}
