<?php

namespace App\Modules\BookingUpgradePassenger\Application\Mask;

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerMask;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;

class BookingUpgradePassengerMasker
{

    private BookingUpgradePassengerRepository $repository;

    public function __construct(BookingUpgradePassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingUpgradePassenger $id, BookingUpgradePassengerMask $mask)
    {
        return new MaskBookingUpgradePassengerResponse($this->repository->mask($id, $mask));
    }
}
