<?php

namespace App\Modules\BookingTourPassenger\Infraestructure;

class BookingTourPassengerValidators
{
    public const INSERT = [
        'Id_Booking'        => 'required|int',
        'Id_Package'        => 'required|int',
        'Id_BookingTour'    => 'required|int',
        'Group'             => 'required|int',
        'BookingTours'      => 'required|string'
    ];

    public const STATUS = [
        'Id_BookingTourPassenger'       => 'required|int',
        'BookingTourPassenger_Status'   => 'required|int'
    ];

    public const UPDATE_PARTIAL = [
        'BookingTourPassenger_HasBeenPrinted'   => 'int|min:1|max:2',
    ];

    public const CANCEL = [
        'Keep_InvoiceDetail'            => 'required|int'
    ];

    public const NULLIFY = [
        'Id_BookingTourPassenger'       => 'required|int',
        'BookingTourPassenger_Status'   => 'required|int',
        'Keep_InvoiceDetail'            => 'required|int'
    ];

    public const STATUS_CHANGE = [
        'Id_BookingTourPassenger'       => 'required|int',
        'BookingTourPassenger_Status'   => 'required|int',
        'Keep_InvoiceDetail'            => 'required|int'
    ];
}
