<?php

namespace App\Modules\BookingTourPassenger\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class BookingTourPassengerStatus extends EnumValueObject
{

    public const NO_TRAVEL = 0;
    public const CANCELLED = 1;
    public const ACTIVE = 2;
    public const REACH = 3;

    public static function values(): array
    {
        return [self::NO_TRAVEL, self::CANCELLED, self::ACTIVE, self::REACH];
    }

    public static function changeFromTo($from, $to)
    {
        $availabilities = [
            self::NO_TRAVEL => [self::CANCELLED, self::ACTIVE, self::REACH],
            self::CANCELLED => [self::ACTIVE, self::NO_TRAVEL, self::REACH],
            self::ACTIVE => [self::NO_TRAVEL, self::CANCELLED, self::REACH],
            self::REACH => [self::CANCELLED, self::NO_TRAVEL, self::ACTIVE],
        ];
        if (isset($availabilities[$from])) {
            if (in_array($to, $availabilities[$from])) {
                return true;
            }
        }
        return false;
    }
}
