<?php

namespace App\Modules\BookingTourPassenger\Application\UpdatePartial;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourPassenger\Application\Index\BookingTourPassengerIndexer;
use App\Modules\BookingTourPassenger\Application\Index\IndexBookingTourPassengerResponse;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerFull;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerHasBeenPrinted;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerHotel;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerLock;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerModel;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerNoValidGroups;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerPaymentStatus;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerPrice;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRemark;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerReportable;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerStatus;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerValidGroups;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdatePartialBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingTourPassengerIndexer $indexer,
        private BookingTourPassengerPartialUpdater $changer
    ) {
    }

    public function __invoke(UpdatePartialBookingTourPassengerQuery $query): UpdatePartialBookingTourPassengerResponse
    {
        /** @var IndexBookingTourPassengerResponse $response */
        $response = $this->indexer->__invoke(new IdBookingTourPassenger($query->id()));
        $index = $response->response()[0];
        $model = new BookingTourPassengerModel(
            new IdBookingTourPassenger($index->Id_BookingTourPassenger),
            new BookingTourPassengerLock($index->BookingTourPassenger_Lock),
            new BookingTourPassengerReportable($index->BookingTourPassenger_Reportable),
            new BookingTourPassengerHotel($index->BookingTourPassenger_Hotel),
            new BookingTourPassengerRemark($index->BookingTourPassenger_Remark),
            new BookingTourPassengerPrice($index->BookingTourPassenger_Price),
            new BookingTourPassengerFull($index->BookingTourPassenger_Full),
            new BookingTourPassengerValidGroups($index->BookingTourPassenger_ValidGroups),
            new BookingTourPassengerNoValidGroups($index->BookingTourPassenger_NoValidGroups),
            new BookingTourPassengerHasBeenPrinted($index->BookingTourPassenger_HasBeenPrinted),
            new BookingTourPassengerStatus($index->BookingTourPassenger_Status),
            new BookingTourPassengerPaymentStatus($index->BookingTourPassenger_PaymentStatus),
            new IdBookingTour($index->Id_BookingTour),
            new IdPassenger($index->Id_Passenger),
        );
        if ($query->hasBeenPrinted()) {
            $model->setHasBeenPrinted(new BookingTourPassengerHasBeenPrinted($query->hasBeenPrinted()));
        }
        return new UpdatePartialBookingTourPassengerResponse($this->changer->__invoke($model));
    }
}
