<?php

namespace App\Modules\BookingTourPassenger\Application\ListByCashMovement;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByCashMovementBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourPassengerByCashMovementLister $lister)
    {
    }

    public function __invoke(ListByCashMovementBookingTourPassengerQuery $query): ListByCashMovementBookingTourPassengerResponse
    {
        return $this->lister->__invoke(
            new IdCashMovement($query->id()),
            $query->action()
        );
    }
}
