<?php

namespace App\Modules\BookingTourItem\Application\ListUpgrade;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourItem\Application\List\BookingTourItemListerResponse;
use App\Modules\BookingTourItem\Domain\UpgradeRepository;

final class UpgradeLister
{
    public function __construct(private UpgradeRepository $repository)
    {
    }

    public function __invoke(IdBookingTour $idBookingTour, string $action): BookingTourItemListerResponse
    {
        return new BookingTourItemListerResponse($this->repository->find($idBookingTour, $action));
    }
}
