<?php

namespace App\Modules\BookingTourItem\Application\List;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class BookingTourItemListerQuery implements Query
{
    public function __construct(
        private int $itemType,
        private int $idBookingTour,
        private string $action
    ) {
    }

    public function getItemType(): int
    {
        return $this->itemType;
    }

    public function getIdBookingTour(): int
    {
        return $this->idBookingTour;
    }
    
    public function getAction(): string
    {
        return $this->action;
    }
}
