<?php

namespace App\Modules\BookingTour\Infraestructure;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingTour\Domain\BookingTour;
use App\Modules\BookingTour\Domain\BookingTourFeeType;
use App\Modules\BookingTour\Domain\BookingTourFull;
use App\Modules\BookingTour\Domain\BookingTourGroup;
use App\Modules\BookingTour\Domain\BookingTourRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Infraestructure\Format1Requester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingTourRepository implements BookingTourRepository
{

    public function index(IdBookingTour $idBookingTour)
    {
        return (new SelectHandler())->handle(
            DB::select(
                'CALL sp_booking_tour_index(?)',
                [
                    $idBookingTour->value()
                ]
            )
        );
    }

    public function find($criteria): BookingTour
    {
        return BookingTour::fromDTO($criteria->run());
    }

    public function search($criteria): array
    {
        return array_map(fn ($btp) => BookingTour::fromDTO($btp), $criteria->run());
    }

    public function updateGroup(IdBooking $idBooking, BookingTourGroup $bookingTourGroup, BookingTourFeeType $feeType, BookingTourFull $full)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_tour_update_group(?,?,?,?,@sts,@cod,@msg)',
            [
                $idBooking->value(),
                $bookingTourGroup->value(),
                $feeType->value(),
                $full->value()
            ]
        );
    }

    public function listByGroup(IdBooking $idBooking, BookingTourGroup $bookingTourGroup)
    {
        return Format1Requester::request(
            'CALL sp_booking_tour_list_by_group(?,?)',
            [
                $idBooking->value(),
                $bookingTourGroup->value()
            ]
        );
    }
}
