<?php

namespace App\Modules\BookingTour\Application;

use App\Modules\BookingTour\Domain\BookingTourPassengerListRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;

class BookingTourPassengerLister
{
    public function __construct(
        private BookingTourPassengerListRepository $passengerListRepository
    ) {
    }

    public function __invoke(string $action, IdBookingTour $idBookingTour, $id, $pathThumb)
    {
        return $this->passengerListRepository->list($action, $idBookingTour, $id, $pathThumb);
    }
}
