<?php

namespace App\Modules\BookingExtraPassenger\Application\Index;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;

final class BookingExtraPassengerIndexer
{
    public function __construct(private BookingExtraPassengerRepository $repository)
    {
    }

    public function __invoke(int $id)
    {
        return $this->repository->index(new IdBookingExtraPassenger($id));
    }
}
