<?php

namespace App\Modules\BookingEquipment\Infraestructure;

use App\Modules\BookingEquipment\Domain\HCHtlUsageDateUsage;
use App\Modules\BookingEquipment\Domain\BookingEquipment;
use App\Modules\BookingEquipment\Domain\BookingEquipmentRepository;
use App\Modules\BookingEquipment\Domain\IdBookingEquipment;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlBookingEquipmentRepository implements BookingEquipmentRepository {

    public function passengerList(string $action, IdBookingTour $id) {
        return Requester::requestSelect(
            'CALL sp_booking_equipment_by_passenger_list(?, ?, @sts, @cod, @msg)',
            [
                $action,
                $id->getValue()
            ]
        );
    }

}
