<?php

namespace App\Modules\BookingCalendar\Domain;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeTour\Domain\IdTypeTour;

interface BookingCalendarRepository
{
    public function tourList(
        IdCategoryTour $idCategoryTour,
        IdTypeTour $idTypeTour,
        IdTour $idTour,
        IdPackage $idPackage,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    );
    public function tourPassengerList(IdTour $idTour, DateStart $dateStart);
}
