<?php

namespace App\Modules\BookingCalendar\Application\ListPassenger;

use App\Modules\BookingCalendar\Domain\BookingCalendarRepository;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class BookingCalendarPassengerLister
{
    public function __construct(private BookingCalendarRepository $repository)
    {
    }

    public function __invoke(
        IdTour $idTour,
        DateStart $dateStart
    ): ListPassengerBookingCalendarResponse {
        return new ListPassengerBookingCalendarResponse($this->repository->tourPassengerList(
            $idTour,
            $dateStart
        ));
    }
}
