<?php

namespace App\Modules\BookingAssign\Infraestructure;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;
use App\Modules\BookingAssign\Domain\IdBookingAssign;
use App\Modules\BookingAssign\Domain\InsertBookingAssign;
use App\Modules\BookingAssign\Domain\UpdateBookingAssign;

class MysqlBookingAssignRepository implements BookingAssignRepository
{

    public function find(IdBooking $idBooking, string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_booking_assign_list(?,?,@sts,@cod,@msg)',
            [
                $idBooking->value(),
                $action
            ]
        );
    }

    public function index(IdBookingAssign $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_booking_assign_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertBookingAssign $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_booking_assign_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->remark()->value(),
                $value->status()->value(),
                $value->idBooking()->value(),
                $value->idAdmin()->value(),
                $value->idTypeBookingAssign()->value(),
            ]
        );
    }

    public function update(UpdateBookingAssign $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_booking_assign_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->remark()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdBookingAssign $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_booking_assign_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
