<?php

namespace App\Modules\BookingAssign\Application\List;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private BookingAssignLister $lister)
    {
    }

    public function __invoke(ListBookingAssignQuery $query): ListBookingAssignQueryResponse
    {
        return $this->lister->__invoke(
            new IdBooking($query->idBooking()),
            $query->action()
        );
    }
}
