<?php

namespace App\Modules\BookingAssign\Application\List;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\BookingAssign\Application\List\ListBookingAssignQueryResponse;
use App\Modules\BookingAssign\Domain\BookingAssignRepository;

final class BookingAssignLister
{
    public function __construct(private BookingAssignRepository $repository)
    {
    }

    public function __invoke(IdBooking $idBooking, string $action): ListBookingAssignQueryResponse
    {
        return new ListBookingAssignQueryResponse($this->repository->find($idBooking, $action));
    }
}
