<?php

namespace App\Modules\BookingAssign\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateBookingAssignQuery implements Query
{
    public function __construct(
        private string $remark,
        private int $status,
        private int $idBooking,
        private int $idAdmin,
        private int $idTypeBookingAssign,
    ) {
    }

    public function remark(): string
    {
        return $this->remark;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idBooking(): int
    {
        return $this->idBooking;
    }
    public function idAdmin(): int
    {
        return $this->idAdmin;
    }
    public function idTypeBookingAssign(): int
    {
        return $this->idTypeBookingAssign;
    }
}
