<?php

namespace App\Modules\BookingAdditional\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class BookingAdditional extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdBookingAdditional::class, 'Id_BookingAdditional'),
            new AggregateAttribute('name', BookingAdditionalName::class, 'BookingAdditional_Name'),
            new AggregateAttribute('abrv', BookingAdditionalAbrv::class, 'BookingAdditional_Abrv'),
            new AggregateAttribute('type', BookingAdditionalType::class, 'BookingAdditional_Type'),
            new AggregateAttribute('status', BookingAdditionalStatus::class, 'BookingAdditional_Status'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('idInternal', Id::class, 'Id'),
        ];
    }

    public function __construct(
        private IdBookingAdditional $id,
        private BookingAdditionalName $name,
        private BookingAdditionalAbrv $abrv,
        private BookingAdditionalType $type,
        private BookingAdditionalStatus $status,
        private IdBookingTourPassenger $idBookingTourPassenger,
        private Id $idInternal,
    ) {
    }

    public function id(): IdBookingAdditional
    {
        return $this->id;
    }

    public function name(): BookingAdditionalName
    {
        return $this->name;
    }

    public function abrv(): BookingAdditionalAbrv
    {
        return $this->abrv;
    }

    public function type(): BookingAdditionalType
    {
        return $this->type;
    }

    public function status(): BookingAdditionalStatus
    {
        return $this->status;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }

    public function idInternal(): Id
    {
        return $this->idInternal;
    }
}
