<?php

namespace App\Modules\BookingAdditional\Application\CreateFromBookingUpgradePassenger;

use App\Modules\BookingAdditional\Application\Create\BookingAdditionalCreator;
use App\Modules\BookingAdditional\Application\Create\CreateBookingAdditionalResponse;
use App\Modules\BookingAdditional\Domain\IdBookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalAbrv;
use App\Modules\BookingAdditional\Domain\BookingAdditionalName;
use App\Modules\BookingAdditional\Domain\BookingAdditionalStatus;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingUpgradePassenger\Application\Index\IndexBookingUpgradePassengerQuery;
use App\Modules\BookingUpgradePassenger\Application\Index\IndexBookingUpgradePassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFromBookingUpgradePassengerBookingAdditionalQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingAdditionalCreator $creator,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(CreateFromBookingUpgradePassengerBookingAdditionalQuery $query): CreateBookingAdditionalResponse
    {
        /** @var IndexBookingUpgradePassengerResponse $index */
        $index = $this->queryBus->ask(new IndexBookingUpgradePassengerQuery($query->idInternal()));
        $model = new BookingAdditional(
                new IdBookingAdditional(0),
                new BookingAdditionalName($index->response()[0]->Upgrade_Name),
                new BookingAdditionalAbrv($index->response()[0]->Upgrade_Code),
                new BookingAdditionalType(BookingAdditionalType::BOOKING_UPGRADE_PASSENGER),
                new BookingAdditionalStatus(BookingAdditionalStatus::ACTIVE),
                new IdBookingTourPassenger($index->response()[0]->Id_BookingTourPassenger),
                new Id($index->response()[0]->Id_BookingUpgradePassenger),
            );
        return $this->creator->__invoke($model);
    }
}
