<?php

namespace App\Modules\BookingAdditional\Application\Create;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\BookingAdditional\Domain\IdBookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalAbrv;
use App\Modules\BookingAdditional\Domain\BookingAdditionalName;
use App\Modules\BookingAdditional\Domain\BookingAdditionalStatus;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateBookingAdditionalQueryHandler implements QueryHandler
{
    public function __construct(private BookingAdditionalCreator $creator)
    {
    }

    public function __invoke(CreateBookingAdditionalQuery $query): CreateBookingAdditionalResponse
    {
        $model = new BookingAdditional(
            new IdBookingAdditional($query->id()),
            new BookingAdditionalName($query->name()),
            new BookingAdditionalAbrv($query->abrv()),
            new BookingAdditionalType($query->type()),
            new BookingAdditionalStatus($query->status()),
            new IdBookingTourPassenger($query->idBookingTourPassenger()),
            new Id($query->idInternal()),
        );
        return $this->creator->__invoke($model);
    }
}
