<?php

namespace App\Modules\Booking\Infraestructure;

use App\Http\Controllers\Owner\CashMovementDetail;
use Illuminate\Support\Facades\DB;

class BookingHistory
{

    private const ITEMS = [
        'Upgrades' => [
            'itemList' => 'CALL sp_booking_upgrade_list_history(?)',
            'passengerList' => 'CALL sp_booking_upgrade_passenger_list_history(?,?)',
            'typeName' => 'Id_BookingUpgrade'
        ],
        'Extras' => [
            'itemList' => 'CALL sp_booking_extra_list(?)',
            'passengerList' => 'CALL sp_booking_extra_passenger_list_history(?,?)',
            'typeName' => 'Id_BookingExtra'
        ],
        'Equipments' => [
            'itemList' => 'CALL sp_booking_equipment_list(?)',
            'passengerList' => 'CALL sp_booking_equipment_passenger_list_history(?,?)',
            'typeName' => 'Id_BookingEquipment'
        ]
    ];

    public static function getHistoryData($idBooking)
    {
        $invoiceListJSON = json_encode(self::getInvoiceListHistory($idBooking));
        return self::getReportDataHistory($idBooking, $invoiceListJSON);
    }

    private static function getInvoiceListHistory($idBooking)
    {
        return DB::select('CALL sp_invoice_list_history(?)', [$idBooking]);
    }

    private static function getReportDataHistory($Id_Booking, $invoiceListJSON)
    {
        return self::mapBookingListHistory(self::getBookingIndexHistory($Id_Booking), $invoiceListJSON);
    }

    private static function getBookingIndexHistory($Id_Booking)
    {
        return DB::select('call sp_booking_index_history(?)', [$Id_Booking]);
    }

    private static function mapBookingListHistory($bookingList, $invoiceListJSON)
    {
        return array_map(
            function ($booking) use ($invoiceListJSON) {

                $booking->Tour              = self::mapTourList(DB::select('call sp_booking_tour_list_history(?)', [$booking->Id_Booking]));
                $booking->Invoice           = self::mapInvoiceList(self::getInvoiceList($booking->Id_Booking));
                $booking->UserCountry_Path  = config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB');

                $passengerParams            = [
                    "all",
                    $booking->Id_Booking,
                    0,
                    "",
                    "",
                    "",
                    "",
                    config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB")
                ];
                $booking->Passengers        = DB::select('call sp_passenger_list_report(?,?,?,?,?,?,?,?)', $passengerParams);

                $booking->Flight            = self::mapFlightList(DB::select('call sp_flight_list(?)', [$booking->Id_Booking]));
                $booking->Room              = self::mapRoomList(DB::select('call sp_room_list(?)', [$booking->Id_Booking]));
                $booking->PayAll            = CashMovementDetail::getAllHistory($invoiceListJSON);
                return $booking;
            },
            $bookingList
        );
    }

    private static function getInvoiceList($Id_Booking)
    {
        return DB::select('call sp_invoice_list_history(?)', [$Id_Booking]);
    }

    private static function mapInvoiceList($invoiceList)
    {
        return array_map(
            function ($invoice) {
                $invoice->Invoice_Detail = DB::select('call sp_invoice_detail_list_history(?)', [$invoice->Id_Invoice]);
                $invoice->Invoice_Fee = DB::select('call sp_invoice_fee_list_history(?)', [$invoice->Id_Invoice]);
                return $invoice;
            },
            $invoiceList
        );
    }

    private static function mapTourList($tourList)
    {
        return array_map(
            function ($tour) {
                $params = [$tour->Id_BookingTour];
                $tour->Passengers = DB::select('call sp_booking_tour_passenger_list_history(?)', $params);

                self::addItem($tour, 'Upgrades', self::ITEMS['Upgrades']);
                self::addItem($tour, 'Extras', self::ITEMS['Extras']);
                self::addItem($tour, 'Equipments', self::ITEMS['Equipments']);

                return $tour;
            },
            $tourList
        );
    }

    private static function mapRoomList($roomList)
    {
        return array_map(function ($room) {
            $room->Passengers = DB::select('call sp_room_passenger_list(?)', [$room->Id_Room]);
            return $room;
        }, $roomList);
    }

    private static function mapFlightList($flightList)
    {
        return array_map(function ($flight) {
            $flight->Passengers = DB::select('call sp_flight_passenger_list(?)', [$flight->Id_Flight]);
            return $flight;
        }, $flightList);
    }

    private static function addItem(&$tour, $itemName, $item)
    {
        $tour->$itemName = array_map(function ($bookingItem) use ($item) {
            $bookingItem->Pax = DB::select($item['passengerList'], [$bookingItem->{$item['typeName']}, 0]);
            return $bookingItem;
        }, DB::select($item['itemList'], [$tour->Id_BookingTour]));
    }
}
