<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingReferredFrom\Domain\IdBookingReferredFrom;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\User\Domain\IdUser;

class Booking extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdBooking::class, 'Id_Booking', 'primary'),
            new AggregateAttribute('date', BookingDate::class, 'Booking_Date'),
            new AggregateAttribute('dateConfirm', BookingDateConfirm::class, 'Booking_DateConfirm'),
            new AggregateAttribute('dateStart', BookingDateStart::class, 'Booking_DateStart'),
            new AggregateAttribute('dateBriefing', BookingDateBriefing::class, 'Booking_DateBriefing'),
            new AggregateAttribute('placeBriefing', BookingPlaceBriefing::class, 'Booking_PlaceBriefing'),
            new AggregateAttribute('code', BookingCode::class, 'Booking_Code'),
            new AggregateAttribute('historyChanges', BookingHistoryChanges::class, 'Booking_HistoryChanges'),
            new AggregateAttribute('hotel', BookingHotel::class, 'Booking_Hotel'),
            new AggregateAttribute('observation', BookingObservation::class, 'Booking_Observation'),
            new AggregateAttribute('internalRemark', BookingInternalRemark::class, 'Booking_InternalRemark'),
            new AggregateAttribute('receipt', BookingReceipt::class, 'Booking_Receipt'),
            new AggregateAttribute('type', BookingType::class, 'Booking_Type'),
            new AggregateAttribute('lastMinute', BookingLastMinute::class, 'Booking_LastMinute'),
            new AggregateAttribute('assigned', BookingAssigned::class, 'Booking_Assigned'),
            new AggregateAttribute('status', BookingStatus::class, 'Booking_Status'),
            new AggregateAttribute('manuallyConfirmed', BookingManuallyConfirmed::class, 'Booking_ManuallyConfirmed'),
            new AggregateAttribute('inPerson', BookingInPerson::class, 'Booking_InPerson'),
            new AggregateAttribute('passengerAmount', BookingPassengerAmount::class, 'Booking_PassengerAmount'),
            new AggregateAttribute('checkedInPassengers', BookingCheckedInPassengers::class, 'Booking_CheckedInPassengers'),
            new AggregateAttribute('lastPassenger', BookingLastPassenger::class, 'Booking_LastPassenger'),
            new AggregateAttribute('token', BookingToken::class, 'Booking_Token'),
            new AggregateAttribute('idBooking_Replace', IdBooking::class, 'Id_Booking_Replace'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('idGuideLanguage', IdLanguage::class, 'Id_GuideLanguage'),
            new AggregateAttribute('idLanguage', IdLanguage::class, 'Id_Language'),
            new AggregateAttribute('idUser', IdUser::class, 'Id_User'),
            new AggregateAttribute('idUser_Additional', IdUser::class, 'Id_User_Additional'),
            new AggregateAttribute('idBookingRelationship', IdBookingRelationship::class, 'Id_BookingRelationship'),
            new AggregateAttribute('idBookingReferredFrom', IdBookingReferredFrom::class, 'Id_BookingReferredFrom'),
        ];
    }

    protected static function table(): string
    {
        return 't_booking';
    }

    public function __construct(
        protected IdBooking $id,
        protected BookingDate $date,
        protected BookingDateConfirm $dateConfirm,
        protected BookingDateStart $dateStart,
        protected BookingDateBriefing $dateBriefing,
        protected BookingPlaceBriefing $placeBriefing,
        protected BookingCode $code,
        protected BookingHistoryChanges $historyChanges,
        protected BookingHotel $hotel,
        protected BookingObservation $observation,
        protected BookingInternalRemark $internalRemark,
        protected BookingReceipt $receipt,
        protected BookingType $type,
        protected BookingLastMinute $lastMinute,
        protected BookingAssigned $assigned,
        protected BookingStatus $status,
        protected BookingManuallyConfirmed $manuallyConfirmed,
        protected BookingInPerson $inPerson,
        protected BookingPassengerAmount $passengerAmount,
        protected BookingCheckedInPassengers $checkedInPassengers,
        protected BookingLastPassenger $lastPassenger,
        protected BookingToken $token,
        protected IdBooking $idBooking_Replace,
        protected IdAdmin $idAdmin,
        protected IdLanguage $idGuideLanguage,
        protected IdLanguage $idLanguage,
        protected IdUser $idUser,
        protected IdUser $idUser_Additional,
        protected IdBookingRelationship $idBookingRelationship,
        protected IdBookingReferredFrom $idBookingReferredFrom,
    ) {}

    public function id(): IdBooking
    {
        return $this->id;
    }

    public function date(): BookingDate
    {
        return $this->date;
    }

    public function dateConfirm(): BookingDateConfirm
    {
        return $this->dateConfirm;
    }

    public function dateStart(): BookingDateStart
    {
        return $this->dateStart;
    }

    public function dateBriefing(): BookingDateBriefing
    {
        return $this->dateBriefing;
    }

    public function placeBriefing(): BookingPlaceBriefing
    {
        return $this->placeBriefing;
    }

    public function code(): BookingCode
    {
        return $this->code;
    }

    public function historyChanges(): BookingHistoryChanges
    {
        return $this->historyChanges;
    }

    public function hotel(): BookingHotel
    {
        return $this->hotel;
    }

    public function observation(): BookingObservation
    {
        return $this->observation;
    }

    public function internalRemark(): BookingInternalRemark
    {
        return $this->internalRemark;
    }

    public function receipt(): BookingReceipt
    {
        return $this->receipt;
    }

    public function type(): BookingType
    {
        return $this->type;
    }

    public function lastMinute(): BookingLastMinute
    {
        return $this->lastMinute;
    }

    public function assigned(): BookingAssigned
    {
        return $this->assigned;
    }

    public function status(): BookingStatus
    {
        return $this->status;
    }

    public function manuallyConfirmed(): BookingManuallyConfirmed
    {
        return $this->manuallyConfirmed;
    }

    public function inPerson(): BookingInPerson
    {
        return $this->inPerson;
    }

    public function passengerAmount(): BookingPassengerAmount
    {
        return $this->passengerAmount;
    }

    public function checkedInPassengers(): BookingCheckedInPassengers
    {
        return $this->checkedInPassengers;
    }

    public function lastPassenger(): BookingLastPassenger
    {
        return $this->lastPassenger;
    }

    public function token(): BookingToken
    {
        return $this->token;
    }

    public function idBooking_Replace(): IdBooking
    {
        return $this->idBooking_Replace;
    }

    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    public function idGuideLanguage(): IdLanguage
    {
        return $this->idGuideLanguage;
    }

    public function idLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }

    public function idUser(): IdUser
    {
        return $this->idUser;
    }

    public function idUser_Additional(): IdUser
    {
        return $this->idUser_Additional;
    }

    public function idBookingRelationship(): IdBookingRelationship
    {
        return $this->idBookingRelationship;
    }

    public function idBookingReferredFrom(): IdBookingReferredFrom
    {
        return $this->idBookingReferredFrom;
    }
}
