<?php

namespace App\Modules\Booking\Application\Report\SalesByPackage;

use Illuminate\Support\Facades\DB;

final class BookingSalesByPackageReporter
{
    public function __construct()
    {
    }

    public function __invoke($dateStart, $dateEnd, $limit)
    {
        // $orderBy = '`b`.`Booking_DateConfirm`';
        $orderBy = '`bt`.`BookingTour_DateStart`';
        return DB::select(
            "SELECT `aux_p`.`Package_Name`,
                -- IF(`Passenger_Amount` IS NULL, 0, SUM(`Passenger_Amount`)) `Pax Amount`,
                COUNT(`Id_Booking`) `Amount`
            FROM `t_package` `aux_p`
            LEFT JOIN (
                SELECT  `b`.`Id_Booking`,
                        `bt`.`Id_Package`,
                        `bt`.`BookingTour_Name`,
                        COUNT(`ps`.`Id_Passenger`) AS `Passenger_Amount`
                FROM `t_booking_tour` `bt`
                INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `bt`.`Id_Booking`
                INNER JOIN `t_package` `p` ON `p`.`Id_Package` = `bt`.`Id_Package`
                INNER JOIN `t_passenger` `ps` ON `ps`.`Id_Booking` = `b`.`Id_Booking`
                WHERE $orderBy BETWEEN ? AND DATE_SUB(?, INTERVAL 1 DAY)
                AND   `b`.`Booking_Status` IN (2, 3)
                AND   `ps`.`Passenger_Status` = 2
                GROUP BY `b`.`Id_Booking`, `bt`.`BookingTour_Group`
            ) `aux` ON `aux`.`Id_Package` = `aux_p`.`Id_Package`
            WHERE `aux_p`.`Package_Status` <> 0 || `Passenger_Amount` IS NOT NULL
            GROUP BY `aux_p`.`Id_Package`
            ORDER BY `aux_p`.`Id_Package`
            LIMIT ?",
            [$dateStart, $dateEnd, $limit]
        );
        // dd($data);
    }
}
