<?php

namespace App\Modules\Booking\Application;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\PaymentBookingRepository;

class PaymentBookingIndexer {

    private PaymentBookingRepository $repository;

    public function __construct(PaymentBookingRepository $repository) {
        $this->repository = $repository;
    }

    public function __invoke (IdBooking $id, string $AdminSession_Token, string $AdminSession_IP, string $path) {
        return $this->repository->index($id, $AdminSession_Token, $AdminSession_IP, $path);
    }
}