<?php

namespace App\Modules\Batch\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class BatchMethod extends EnumValueObject
{
    public const METHOD_GET = 'get';
    public const METHOD_POST = 'post';
    public const METHOD_PUT = 'put';
    public const METHOD_DELETE = 'delete';

    public function __construct($value)
    {
        parent::__construct($value);
    }

    public static function values()
    {
        return [
            self::METHOD_GET,
            self::METHOD_POST,
            self::METHOD_PUT,
            self::METHOD_DELETE,
        ];
    }
}
