<?php

namespace App\Modules\Batch\Application\Run;

use App\Modules\Batch\Domain\Batch;
use App\Modules\Batch\Domain\BatchRequest;
use App\Modules\Batch\Domain\BatchResource;
use App\Modules\Batch\Domain\RouteDispatcher;

final class BatchRunner
{
    public function __construct(
        private RouteDispatcher $dispatcher
    ) {
    }

    public function __invoke(Batch $batch): RunBatchQueryResponse
    {
        $v = $this;
        $responses = [];
        $response = array_map(
            function (BatchRequest $request, $key) use ($v, &$responses) {
                $request->setResource(BatchResource::generateResource($request->resource()->value(), $responses));
                $result = $v->dispatcher->dispatch($request);
                $responses['r' . ($key + 1)] = $result;
                return $result;
            },
            $batch->requests(),
            array_keys($batch->requests())
        );
        return new RunBatchQueryResponse($response);
    }
}
